/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/

//=========================================================================================
//------ STAGE RESIZE
//=========================================================================================
var stageListener:Object  = new Object();
Stage.addListener(stageListener);
stageListener.onResize = function() { 
	resizeStage(); 
};


function resizeStage():Void {
	var newX:Number = Math.round(Stage.width/2);
	var newY:Number = Math.round(Stage.height/2);
	
	// move bgroundBox_mc
	mainTL.bgroundBox_mc._x = newX;
	mainTL.bgroundBox_mc._y = newY;
	mainTL.bgroundBox_mc._width = Stage.width;
	mainTL.bgroundBox_mc._height = Stage.height;
	
	// if error, move that too
	mainTL.error_mc.slideTo(newX, newY, 1, 'easeInOutExpo', .125);
	
	// if photo, move that too
	mainTL.large_mc.slideTo(newX, newY, 1, 'easeInOutExpo', .125);
	
	
	
	background_mc.slideTo(newX, newY, 1, 'easeInOutExpo', .125);
	repositionSite();
};


function repositionSite():Void {
	// move copy
	gallery_mc.slideTo(Math.round((Stage.width/2) - (gallery_mc._width/2)), Math.round((Stage.height/2) - (gallery_mc.mask_mc._height/2)), 1, "easeInOutExpo", .125);
	
}